#!/usr/bin/env python
# -*- coding: utf-8 -*- 
# -------------------------------------------------------------------------------------
# Na podstawie: test-invert-layer.py
# Copyright (c) 2013, Jose F. Maldonado
# All rights reserved.
#
# Ten plik jest podstawowym przykładem wtyczki Python dla GIMP.
#
# To może być wykonane poprzez wybranie opcji w menu: '/TEST/Testowanie/Odwróć kolory'


from gimpfu import *

def invert_drw(img, drawable) :
    ''' Odwraca kolory otwrtego obrazu.
    
    Parametry:
    img : image Aktualny obraz.
    drawable : drawable aktualnego obrazu.
    '''
    pdb.gimp_invert(drawable)

register(
    "test_invert_drw",
    "Odwraca kolory",
    "Jednym kliknięciem Etykiety, odwraca kolory otwartego obrazu",
    "JFM, Modified Zbyma72age",
    "Open source (BSD 3-clause license)",
    "2013, Modified 2015",
    "Odwróć kolory", # Etykieta
    "*",
    [],
    [],
    invert_drw,
	menu="<Image>/TEST/Testowanie"
	)
"""
Licencja typu BSD skupia się na prawach użytkownika. Jest bardzo liberalna, 
zezwala nie tylko na modyfikacje kodu i jego rozprowadzanie w takiej postaci, 
ale także na rozprowadzanie produktu bez postaci źródłowej czy wręcz włączenia 
do zamkniętego oprogramowania, pod warunkiem załączenia do produktu informacji 
o autorach oryginalnego kodu i treści licencji.
"""	
main()
